<?php declare(strict_types=1);

namespace VideoAISoftware\Content;

use Shopware\Core\Content\Media\MediaDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use VideoAISoftware\Content\ProductAiVideo\ProductAiVideoDefinition;

class MediaExtension extends EntityExtension
{

    /**
     * @inheritDoc
     */
    public function getDefinitionClass(): string
    {
        return MediaDefinition::class;
    }

    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            new OneToManyAssociationField(
                ProductAiVideoDefinition::ENTITY_EXTENSION,
                ProductAiVideoDefinition::class,
                'media_id',
            )
        );
    }
}