<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductSetting\Media;

use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition;
use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use VideoAISoftware\Constants;

#[AutoconfigureTag('entity.definition', ['entity' => self::ENTITY_NAME])]
class ProductSettingMediaDefinition extends EntityDefinition {
    
    public const ENTITY_NAME = Constants::DATABASE_NAMESPACE . '_product_video_config_media';
    public const ENTITY_EXTENSION = Constants::NAMESPACE . 'ProductVideoConfigMedia';

    public function getEntityName() : string {
        return self::ENTITY_NAME;
    }

    protected function defineFields() : FieldCollection {
        return new FieldCollection([
            (new FkField('product_id', 'productId', ProductDefinition::class))->addFlags(new PrimaryKey(),new Required()),
            (new ReferenceVersionField(ProductDefinition::class))->addFlags(new Required()),
            (new FkField('product_media_id', 'productMediaId', ProductMediaDefinition::class))->addFlags(new PrimaryKey(), new Required()),
            new OneToOneAssociationField('product', 'product_id', 'id', ProductDefinition::class, false),
            new OneToOneAssociationField('productMedia', 'product_media_id', 'id', ProductMediaDefinition::class, false),
        ]);
    }

    public function getEntityClass(): string
    {
        return ProductSettingMediaEntity::class;
    }

    public function getCollectionClass(): string 
    {
        return ProductSettingMediaCollection::class;
    }
}