<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductSetting;

use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;

class ProductSettingEntity extends Entity {

    protected string $productVersionId;

    protected ?string $videoTemplateId;

    protected ?bool $useProductProperties;
    protected ?bool $useManufacturerInformation;
    protected ?bool $useProductPrice;
    protected ?bool $useProductImages;
    protected ?string $formOfAddress;

    protected  ?string $additionalInstructions;
    protected  ?string $excludedContent;
    protected ?string $additionalVideoContent;

    protected ?string $videoScriptState;
    protected ?array $videoScriptError;
    protected ?array $videoScript;

    protected ?string $generateVideoState;
    protected ?array $generateVideoError;

    protected ?ProductEntity $product = null;
    
    public function getProductVersionId() : string {
        return $this->productVersionId;
    }

    public function getProduct(): ?ProductEntity {
        return $this->product;
    }

    public function setVideoTemplate(string $templateId) {
        $this->videoTemplateId = $templateId;
    }

    public function getVideoTemplateId() : ?string {
        return $this->videoTemplateId;
    }

    public function setUseProductProperties(bool $useProductProperties) {
        $this->useProductProperties = $useProductProperties;
    }

    public function getUseProductProperties() : ?bool {
        return $this->useProductProperties;
    }

    public function setUseManufacturerInformation(bool $useManufacturerInformation) {
        $this->useManufacturerInformation = $useManufacturerInformation;
    }

    public function getUseManufacturerInformation() : ?bool {
        return $this->useManufacturerInformation;
    }

    public function setUseProductPrice(bool $useProductPrice) {
        $this->useProductPrice = $useProductPrice;
    }

    public function getUseProductPrice() : ?bool {
        return $this->useProductPrice;
    }

    public function setUseProductImages(bool $useProductImages) {
        $this->useProductImages = $useProductImages;
    }

    public function getUseProductImages() : ?bool {
        return $this->useProductImages;
    }

    public function setAdditionalVideoContent(string $additionalVideoContent) {
        $this->additionalVideoContent = $additionalVideoContent;
    }

    public function getAdditionalVideoContent() : ?string {
        return $this->additionalVideoContent;
    }

    public function getAdditionalInstructions(): ?string
    {
        return $this->additionalInstructions;
    }

    public function setAdditionalInstructions(?string $additionalInstructions): void
    {
        $this->additionalInstructions = $additionalInstructions;
    }

    public function getExcludedContent(): ?string
    {
        return $this->excludedContent;
    }

    public function setExcludedContent(?string $excludedContent): void
    {
        $this->excludedContent = $excludedContent;
    }

    public function getVideoScriptError(): ?array
    {
        return $this->videoScriptError;
    }

    public function setVideoScriptError(?array $videoScriptError): void
    {
        $this->videoScriptError = $videoScriptError;
    }

    public function getVideoScript(): ?array
    {
        return $this->videoScript;
    }

    public function setVideoScript(?array $videoScript): void
    {
        $this->videoScript = $videoScript;
    }
    public function getFormOfAddress(): ?string
    {
        return $this->formOfAddress;
    }

    public function setFormOfAddress(?string $formOfAddress): void
    {
        $this->formOfAddress = $formOfAddress;
    }


    public function getVideoScriptState(): ?VideoScriptState
    {
        return VideoScriptState::tryFrom($this->videoScriptState ?? '');
    }

    public function setVideoScriptState(?VideoScriptState $videoScriptState): void
    {
        $this->videoScriptState = $videoScriptState->value;
    }

    public function getGenerateVideoState(): ?GenerateVideoState
    {
        return GenerateVideoState::tryFrom($this->generateVideoState ?? '');
    }

    public function setGenerateVideoState(?GenerateVideoState $generateVideoState): void
    {
        $this->generateVideoState = $generateVideoState?->value;
    }

    public function getGenerateVideoError(): ?array
    {
        return $this->generateVideoError;
    }

    public function setGenerateVideoError(?array $generateVideoError): void
    {
        $this->generateVideoError = $generateVideoError;
    }

}