<?php declare(strict_types=1);

namespace VideoAISoftware\Controller\Api;

use Shopware\Core\Framework\Api\Controller\ApiController;
use Shopware\Core\Framework\Validation\DataBag\RequestDataBag;
use Symfony\Component\HttpClient\Exception\ClientException;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use VideoAISoftware\Component\Api\MiddlewareClientFactory;

#[Route(defaults: ['_routeScope' => ['api']])]
class ApiValidationController extends ApiController
{
    #[Route(path: '/api/api-validation/verify', name: 'api.action.api-test.verify', methods: ['POST'])]
    public function check(RequestDataBag $dataBag, MiddlewareClientFactory $clientFactory): JsonResponse
    {
        $client = $clientFactory->create($dataBag->get('apiKey'));

        try {
            $client->request('GET', 'tokens/validate');
            return new JsonResponse();
        } catch (ClientException $exception) {
            return new JsonResponse($exception->getResponse()->toArray(false), $exception->getCode());
        }
    }
}