<?php

namespace VideoAISoftware\Controller\Api;

use Shopware\Core\Framework\Api\Controller\ApiController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpClient\Exception\ClientException;
use VideoAISoftware\Component\Api\MiddlewareClientFactory;

#[Route(defaults: ['_routeScope' => ['api']])]
class FetchUsageStatisticsController extends ApiController
{
    #[Route(path: '/api/usage-statistics/get-usage-statistics', name: 'api.action.usage-statistics.get', methods: ['GET'])]
    public function fetchUsageStatistics(Request $request, MiddlewareClientFactory $clientFactory): JsonResponse
    {
        try {
            $client = $clientFactory->create();
            $response = $client->request('GET', 'statistics');

            return new JsonResponse(['success' => true, 'statistics' => $response->toArray()['statistics']]);
        } 
        catch (ClientException $exception) 
        {
            return new JsonResponse($exception->getResponse()->toArray(false), $exception->getCode());
        }
    }


}
