<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1729698048CreateMwsVaisProductConfigTable extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1729698048;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
        CREATE TABLE mws_vais_product_video_config (
            product_id BINARY(16) NOT NULL, 
            product_version_id BINARY(16) NOT NULL,
            video_template_id VARCHAR(255),
            use_product_name TINYINT(1),
            use_product_description TINYINT(1),
            use_product_properties TINYINT(1),
            use_manufacturer_info TINYINT(1),
            use_product_price TINYINT(1),
            use_product_images TINYINT(1),
            additional_video_content TEXT, 
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY(product_id),
            FOREIGN KEY (product_id, product_version_id) 
                REFERENCES product(id, version_id) 
                ON DELETE CASCADE,
            KEY `mws_vais_product_video_config.fk.product_id` (product_id)
        ) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB;
        SQL;

$connection->executeStatement($query);

    }
}
