<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1733306520RemoveProductVideoConfigUseFlagsDefault extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1733306520;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement(<<<SQL
            ALTER TABLE mws_vais_product_video_config
                CHANGE use_manufacturer_info use_manufacturer_info tinyint(1) null default (null),
                CHANGE use_product_images use_product_images tinyint(1) null default (null),
                CHANGE use_product_price use_product_price tinyint(1) null default (null),
                CHANGE use_product_properties use_product_properties tinyint(1) null default (null);
        SQL);
    }
}
