const ApiService = Shopware.Classes.ApiService;


export default class FetchMinuteAccountService extends ApiService {

    constructor(httpClient, loginService, apiEndpoint = 'minute-account') {
        super(httpClient, loginService, apiEndpoint);
    }

    getMinuteAccount(params) {
        const headers = this.getBasicHeaders();
        return this.httpClient.get(
            `${this.getApiBasePath()}/get-minute-account`,
            {
                headers,
                params
            }
        ).then((response) => {
            return ApiService.handleResponse(response);
        }).catch((error) => {
            console.error('Error retrieving minute account:', error);
            throw error;
        });
    }
}