const ApiService = Shopware.Classes.ApiService;

export default class ProductMediaSettings extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'product-media-settings') {
        super(httpClient, loginService, apiEndpoint);
    }

    async fetchSelectedMedia(params) {
        const headers = this.getBasicHeaders();

        return this.httpClient.get(
            `${this.getApiBasePath()}/get`,
            {
                headers,
                params
            }
        ).then((response) => {
            return ApiService.handleResponse(response);
        }).catch((error) => {
            console.error('Error while fetching selected media:', error);
            throw error;
        });
    }

    async saveSelectedMedia(params) {
        const headers = super.getBasicHeaders();
    
        const response = await super.httpClient.post(
            `${this.getApiBasePath()}/save`,
            params,
            { headers }
        );
    
        return ApiService.handleResponse(response);
    }
}