<?php

declare(strict_types=1);

namespace VideoAISoftware\Component\Notification;

use DateTime;
use DateTimeInterface;
use Shopware\Administration\Notification\NotificationService as ShopwareNotificationService;
use VideoAISoftware\Util\ContextHelper;

readonly class NotificationService
{
    public function __construct(
        private ContextHelper $contextHelper,
        private ShopwareNotificationService $notificationService
    )
    {
    }

    public function createNotification(
        string $notificationKey,
        array $payload,
        ?string $userId = null,
        ?string $integrationId = null
    ): void
    {
        $this->notificationService->createNotification([
            'status' => $notificationKey,
            'message' => json_encode([
                'timestamp' => (new DateTime())->format(DateTimeInterface::ATOM), // Can't access notification createdAt in administration service ...
                ...$payload
            ]),
            'createdByUserId' => $userId,
            'createdByIntegrationId' => $integrationId
        ], $this->contextHelper->createCliContext());
    }
}