<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductAiVideo;

use Shopware\Core\Content\Media\MediaDefinition;
use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition;
use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\SetNullOnDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\Language\LanguageDefinition;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use VideoAISoftware\Constants;

#[AutoconfigureTag('entity.definition', ['entity' => self::ENTITY_NAME])]
class ProductAiVideoDefinition extends EntityDefinition
{
    public const ENTITY_NAME = Constants::DATABASE_NAMESPACE . '_product_ai_video';
    public const ENTITY_EXTENSION = Constants::NAMESPACE . 'ProductAiVideo';

    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),
            (new FkField('product_id', 'productId', ProductDefinition::class))->addFlags(new Required()),
            (new ReferenceVersionField(ProductDefinition::class))->addFlags(new Required()),
            (new FkField('media_id', 'mediaId', MediaDefinition::class))->addFlags(new Required()),
            new FkField('product_media_id', 'productMediaId', ProductMediaDefinition::class),
            new ReferenceVersionField(ProductMediaDefinition::class, 'product_media_version_id'),
            #(new FkField('language_id', 'languageId', LanguageDefinition::class))->addFlags(new PrimaryKey(), new Required()),
            (new OneToOneAssociationField('media', 'media_id', 'id', MediaDefinition::class, false))
                ->addFlags(new CascadeDelete()),
            (new OneToOneAssociationField('product', 'product_id', 'id', ProductDefinition::class, false))
                ->addFlags(new CascadeDelete()),
            (new OneToOneAssociationField('productMedia', 'product_media_id', 'id', ProductMediaDefinition::class, false))
                ->addFlags(new SetNullOnDelete()),
            #new OneToOneAssociationField('language', 'language_id', 'id', LanguageDefinition::class, false),
            new BoolField('published', 'published'),
            new FkField('parent_id', 'parentId', self::class),
            (new OneToOneAssociationField('parent', 'parent_id', 'id', self::class, false))->addFlags(new CascadeDelete()),
            (new OneToManyAssociationField('children', self::class, 'parent_id'))


        ]);
    }

    public function getEntityClass(): string
    {
        return ProductAiVideoEntity::class;
    }

    public function getCollectionClass(): string
    {
        return ProductAiVideoCollection::class;
    }
}