<?php

namespace VideoAISoftware\Controller\Api;

use Shopware\Core\Framework\Api\Controller\ApiController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use VideoAISoftware\Component\Api\MiddlewareClientFactory;

#[Route(defaults: ['_routeScope' => ['api']])]
class FetchMinuteAccountController extends ApiController
{
    #[Route(path: '/api/minute-account/get-minute-account', name: 'api.action.minute-account.get', methods: ['GET'])]
    public function fetchMinuteAccount(Request $request, MiddlewareClientFactory $clientFactory): JsonResponse
    {

        try {
            $client = $clientFactory->create();
            $response = $client->request('GET', 'virtual-account');

            return new JsonResponse(['success' => true, 'minutes' => $response->toArray()['minutes']]);
        } catch (ClientException $exception) {
            return new JsonResponse($exception->getResponse()->toArray(false), $exception->getCode());
        }
    }
}
