<?php

namespace VideoAISoftware\Controller\Api;

use Shopware\Core\Framework\Api\Controller\ApiController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use VideoAISoftware\Component\Api\MiddlewareClientFactory;

#[Route(defaults: ['_routeScope' => ['api']])]
class FetchVideoTemplatesController extends ApiController
{
    #[Route(path: '/api/video-templates/get-video-templates', name: 'api.action.video-templates.get', methods: ['GET'])]
    public function fetchVideoTemplates(Request $request, MiddlewareClientFactory $clientFactory): JsonResponse
    {
        $client = $clientFactory->create($request->query->get('apiKey'));

        $result = $client->request('GET', 'templates');
        return new JsonResponse(['templates' => $result->toArray()]);
    }



}
