<?php declare(strict_types=1);

namespace VideoAISoftware\Exception;

use Exception;
use Throwable;

class ParseUrlException extends Exception
{
    public function __construct(string $url, int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct("Could not parse url '$url'", $code, $previous);
    }
}