<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use DateTime;
use Doctrine\DBAL\Connection;
use Shopware\Core\Defaults;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Uuid\Uuid;
use VideoAISoftware\Content\ProductAiVideo\ProductAiVideoDefinition;

/**
 * @internal
 */
#[Package('core')]
class Migration1729603309create_product_ai_video_folder extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1729603309;
    }

    public function update(Connection $connection): void
    {
        $defaultFolderId = Uuid::randomHex();

        $connection->executeStatement(<<<SQL
            INSERT INTO media_default_folder (id, entity, created_at) values (
                :id,
                :entity,
                :createdAt
            )  
        SQL, [
            'id' => Uuid::fromHexToBytes($defaultFolderId),
            'entity' => ProductAiVideoDefinition::ENTITY_NAME,
            'createdAt' => (new DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
        ]);


        $connection->executeStatement(<<<SQL
            INSERT INTO media_folder (id, default_folder_id, name, created_at) values (
                :id,
                :defaultFolderId,
                :name,
                :createdAt
            )
        SQL, [
            'id' => Uuid::fromHexToBytes(Uuid::randomHex()),
            'defaultFolderId' => Uuid::fromHexToBytes($defaultFolderId),
            'name' => 'Product AI Media',
            'createdAt' => (new DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
        ]);

    }
}
