<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1730296078MwsVaisProductVideoConfig extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730296078;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            ALTER TABLE mws_vais_product_video_config DROP use_product_name, DROP use_product_description;
        SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
