<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1731573259MwsVaisProductAiVideo extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1731573259;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            CREATE TABLE mws_vais_product_ai_video (
                id BINARY(16) NOT NULL, 
                product_id BINARY(16) NOT NULL, 
                product_version_id BINARY(16) DEFAULT NULL, 
                media_id BINARY(16) NOT NULL, 
                product_media_id BINARY(16) DEFAULT NULL, 
                product_media_version_id BINARY(16) DEFAULT NULL, 
                published TINYINT(1) DEFAULT 0, 
                created_at DATETIME NOT NULL, 
                updated_at DATETIME DEFAULT NULL, 
                PRIMARY KEY(id),
                CONSTRAINT `fk.mws_vais_product_ai_video.media_id` FOREIGN KEY (media_id) 
                    REFERENCES media (id) ON UPDATE CASCADE ON DELETE CASCADE,
                CONSTRAINT `fk.mws_vais_product_ai_video.product_id` FOREIGN KEY (product_id, product_version_id) 
                    REFERENCES product (id, version_id) ON UPDATE CASCADE ON DELETE CASCADE,
                CONSTRAINT `fk.mws_vais_product_ai_video.product_media_id` FOREIGN KEY (product_media_id, product_media_version_id) 
                    REFERENCES product_media (id, version_id) ON UPDATE CASCADE ON DELETE SET NULL
            ) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
