const { join, resolve } = require('path');

module.exports = (params) => {
    return {
        resolve: {
            alias: {
                // Alias to plugin root
                "@MwsVais": `${params.basePath}/Resources/app/administration/src/`, // params.basePath = {plugin_root}/src
                // "@administration": "/var/www/html/vendor/shopware/administration/Resources/app/administration/src", -> already defined by shopware
                // ~administration needed for scss
                "~administration": "/var/www/html/vendor/shopware/administration/Resources/app/administration/src",
                // Alias dependencies using shopware 6.4 documentation (https://developer.shopware.com/docs/v6.4/guides/plugins/plugins/plugin-fundamentals/using-npm-dependencies.html#registering-a-package-in-the-build-system)
                // Shopware 6.6 documentation does NOT work and breaks at least the admin watcher (https://developer.shopware.com/docs/guides/plugins/plugins/plugin-fundamentals/using-npm-dependencies.html#registering-a-package-in-the-build-system)
                // Prefixed with namespace to avoid conflicts with other plugins
                '@MwsVais@mitt': resolve(
                    join(__dirname, '..', 'node_modules', 'mitt')
                )
            },
        }
    };
}