// eslint-disable-next-line plugin-rules/no-src-imports
import BulkEditBaseHandler from '@administration/module/sw-bulk-edit/service/handler/bulk-edit-base.handler';
// eslint-disable-next-line plugin-rules/no-src-imports
import RetryHelper from '@administration/core/helper/retry.helper';

const types = Shopware.Utils.types;

export default class MwsvaisAiBulkEditProductHandler extends BulkEditBaseHandler {
    constructor() {
        super();
        this.name = 'mwsvaisAiBulkEditProductHandler';
        this.entityName = 'mws_vais_product_video_config';
    }

    async bulkEdit(entityIds, payload) {

        this.entityIds = entityIds;

        const syncPayload = await this.buildBulkSyncPayload(payload);
        if (types.isEmpty(syncPayload)) {
            return Promise.resolve(
                {
                    data: [],
                }
            );
        }

        syncPayload["upsert-mws_vais_product_video_config"]["payload"].forEach(item => {
            item.productId = item.id;
            delete item.id;
        });

        const syncPayloadStringified = JSON.stringify(syncPayload, (k, v) => (v === undefined ? null : v));
        return RetryHelper.retry(() => {
            return this.syncService.sync(syncPayloadStringified, {}, {
                'single-operation': 1,
                'sw-language-id': Shopware.Context.api.languageId,
            });
        });

    }


}