import template from './mwsvais-ai-bulk-edit.html.twig';
import MwsvaisAiBulkEditProductHandler from './bulk-edit.handler';
const { chunk } = Shopware.Utils.array;
const { cloneDeep } = Shopware.Utils.object;

export default {
    template,

    compatConfig: Shopware.compatConfig,

    inject: [
        'feature',
        'repositoryFactory',
        'fetchVideoTemplates'
    ],

    data() {
        return {
            isLoading: false,
            isLoadedData: false,
            isSaveSuccessful: false,
            bulkEditVideoSetting: {},
            bulkEditSelected: [],
            processStatus: '',

            isComponentMounted: true,
            entity: null,
            videoTemplates: []
        };
    },

    metaInfo() {
        return {
            title: this.$createTitle(),
        };
    },

    computed: {
        bulkEditHandler() {
            return new MwsvaisAiBulkEditProductHandler();
        },

        videoConfigRepository() {
            return this.repositoryFactory.create('mws_vais_product_video_config');
        },

        selectedIds() {
            return Shopware.State.get('shopwareApps').selectedIds;
        },

        hasSelectedChanges() {
            return Object.values(this.bulkEditVideoSetting).some(field => field.isChanged) || this.bulkEditSelected.length > 0;
        },

        mwsvaisBulkTranscriptControl() {
            return [
                {
                    name: 'additionalInstructions',
                    type: 'text',
                    canInherit: false,
                    config: {
                        componentName: 'sw-textarea-field',
                        placeholder: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.additionalAIInstructions.placeholder'),
                        changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.additionalAIInstructions.changeLabel'),
                    },
                },
                {
                    name: 'excludedContent',
                    type: 'text',
                    canInherit: false,
                    config: {
                        componentName: 'sw-textarea-field',
                        placeholder: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.leftOutInformation.placeholder'),
                        changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.leftOutInformation.changeLabel'),
                    },
                }
            ];
        },

        mwsvaisBulkDefaultVideoSettings() {
            return [{
                //Video Template
                name: 'videoTemplateId',
                type: 'string',
                canInherit: true,
                config: {
                    componentName: 'sw-single-select',
                    options: this.videoTemplates,
                    valueProperty: 'id',
                    labelProperty: 'name',
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.videoTemplate.changeLabel'),
                    placeholder: this.$tc('mwsvais-bulk-edit.ai-video.videoTemplate.placeholder'),
                    disabled: this.bulkEditVideoSetting?.videoTemplateId?.isInherited,
                },
            },{
                name: 'formOfAddress',
                type: 'string',
                canInherit: true,
                config: {
                    componentName: 'sw-single-select',
                    options: [
                        {
                            value: 'Du',
                            label: 'Du'
                        },
                        {
                            value: 'Sie',
                            label: 'Sie'
                        }
                    ],
                    labelProperty: 'label',
                    valueProperty: 'value',
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.formOfAddress.changeLabel'),
                    placeholder: this.$tc('mwsvais-bulk-edit.ai-video.formOfAddress.placeholder'),
                    disabled: this.bulkEditVideoSetting?.formOfAddress?.isInherited,
                },
            }, {
                //Product properties
                name: 'useProductProperties',
                type: 'bool',
                canInherit: true,
                config: {
                    type: 'switch',
                    label: this.$tc('mwsvais-bulk-edit.ai-video.useProductProperties.switchLabel'),
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.useProductProperties.changeLabel'),
                    disabled: this.bulkEditVideoSetting?.useProductProperties?.isInherited,
                },
            }, {
                name: 'useManufacturerInformation',
                type: 'bool',
                canInherit: true,
                config: {
                    type: 'switch',
                    label: this.$tc('mwsvais-bulk-edit.ai-video.useProductManufacturerInformation.switchLabel'),
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.useProductManufacturerInformation.changeLabel'),
                    disabled: this.bulkEditVideoSetting?.useManufacturerInformation?.isInherited,
                },
            }, {
                name: 'useProductPrice',
                type: 'bool',
                canInherit: true,
                config: {
                    type: 'switch',
                    label: this.$tc('mwsvais-bulk-edit.ai-video.useProductPrice.switchLabel'),
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.useProductPrice.changeLabel'),
                    disabled: this.bulkEditVideoSetting?.useProductPrice?.isInherited,
                },
            }, {
                name: 'useProductImages',
                type: 'bool',
                canInherit: true,
                config: {
                    type: 'switch',

                    label: this.$tc('mwsvais-bulk-edit.ai-video.useProductImages.switchLabel'),
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.useProductImages.changeLabel'),
                    disabled: this.bulkEditVideoSetting?.useProductImages?.isInherited,
                },
            },
            {
                name: 'additionalVideoContent',
                type: 'text',
                canInherit: false,
                config: {
                    componentName: 'sw-textarea-field',
                    placeholder: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.additionalVideoContent.placeholder'),
                    changeLabel: this.$tc('mwsvais-bulk-edit.ai-video.videoInformation.additionalVideoContent.changeLabel'),
                },
            } ];
        },
    },

    created() {
        this.createdComponent();
    },

    methods: {
        async createdComponent() {
            this.setRouteMetaModule();
            this.isLoading = true;

            await this.loadVideoTemplates()
            this.entity = this.videoConfigRepository.create()
            this.loadBulkEditData();
            this.isLoading = false;
            this.isLoadedData = true;
        },

        async loadVideoTemplates() {
            const response = await this.fetchVideoTemplates.getVideoTemplates();

            this.videoTemplates = response.templates.map(template => ({
                id: template.id,
                name: template.title,
            }));
        },

        setRouteMetaModule() {
            if (this.isCompatEnabled && this.isCompatEnabled('INSTANCE_SET')) {
                this.$set(this.$route.meta.$module, 'color', '#57D9A3');
                this.$set(this.$route.meta.$module, 'icon', 'regular-products');
            } else {
                this.$route.meta.$module.color = '#57D9A3';
                this.$route.meta.$module.icon = 'regular-products';
            }
        },


        defineBulkEditData(name, value = null, type = 'overwrite', isChanged = false) {
            if (this.bulkEditVideoSetting[name]) {
                return;
            }

            if (this.isCompatEnabled && this.isCompatEnabled('INSTANCE_SET')) {
                this.$set(this.bulkEditVideoSetting, name, {
                    isChanged: isChanged,
                    type: type,
                    value: value,
                    isInherited: false,
                });
            } else {
                this.bulkEditVideoSetting[name] = {
                    isChanged: isChanged,
                    type: type,
                    value: value,
                    isInherited: false,
                };
            }
        },

        loadBulkEditData() {
            const bulkEditFormGroups = [
                this.mwsvaisBulkDefaultVideoSettings,
                this.mwsvaisBulkTranscriptControl

            ];

            bulkEditFormGroups.forEach((bulkEditForms) => {
                bulkEditForms.forEach((bulkEditForm) => {
                    this.defineBulkEditData(bulkEditForm.name);
                });
            });
        },

        onProcessData() {
            Object.keys(this.bulkEditVideoSetting).forEach(key => {
                const bulkEditField = cloneDeep(this.bulkEditVideoSetting[key]);
                if (!bulkEditField.isChanged) {
                    return;
                }

                let bulkEditValue = this.entity[key];

                if (bulkEditField.isInherited) {
                    bulkEditValue = null;
                }

                const change = {
                    field: key,
                    type: bulkEditField.type,
                    value: bulkEditValue,
                };

                this.bulkEditSelected.push(change);
            });
        },
        openModal() {
            this.isComponentMounted = false;
            this.$router.push({
                name: 'mwsvais.ai.bulk.edit.product.save',
                params: {
                    parentId: this.$route.params.parentId,
                },
            });
        },

        async onSave() {
            this.isLoading = true;
            this.onProcessData();

            const payloadChunks = chunk(this.selectedIds, 50);

            const requests = payloadChunks.map(payload => {
                return this.bulkEditHandler.bulkEdit(payload, this.bulkEditSelected);
            });


            this.bulkEditSelected = [];


            return Promise.all(requests)
                .then(response => {
                    const isSuccessful = response.every(item => item.data);
                    this.processStatus = isSuccessful ? 'success' : 'fail';
                }).catch((
                    e
                ) => {
                    this.processStatus = 'fail';
                }).finally(() => {
                    this.isLoading = false;
                });
        },


        closeModal() {
            this.$router.push({ name: 'mwsvais.ai.bulk.edit.product' });
        },

        onChangeLanguage(languageId) {
            Shopware.State.commit('context/setApiLanguageId', languageId);
        },

        onInheritanceRestore(item) {
            if (this.isCompatEnabled && this.isCompatEnabled('INSTANCE_SET')) {
                this.$set(this.bulkEditVideoSetting[item.name], 'isInherited', true);
                this.$set(this.bulkEditVideoSetting[item.name], 'value', null);
            } else {
                this.bulkEditVideoSetting[item.name].isInherited = true;
                this.bulkEditVideoSetting[item.name].value = null;
            }

            this.$set(this.entity, item.name, null);
        },

        onInheritanceRemove(item) {
            if (this.isCompatEnabled && this.isCompatEnabled('INSTANCE_SET')) {
                this.$set(this.bulkEditVideoSetting[item.name], 'isInherited', false);
            } else {
                this.bulkEditVideoSetting[item.name].isInherited = false;
            }
        },
    },
};
