import template from './mwsvais-video-templates.html.twig';

const { Component } = Shopware;

Component.register('mwsvais-video-templates', {
    template,
    inject: ['fetchVideoTemplates'],

    props: ['value'],
    emits: ['update:value'],

    data() {
        return {
            isLoading: true,
            videoTemplates: [],
        };
    },

    created() {
        this.loadVideoTemplates();
    },

    methods: {
        async loadVideoTemplates() {
            this.isLoading = true;

            const response = await this.fetchVideoTemplates.getVideoTemplates();

            this.videoTemplates = response.templates.map(template => ({
                id: template.id,
                name: template.title,
            }));
        },

        onTemplateClick(value) {
            this.$emit('update:value', value)
        }
    }
});
