import template from './sw-product-detail.html.twig';
import emitter from "@MwsVais/util/mitt";

const {Criteria} = Shopware.Data;

Shopware.Component.override('sw-product-detail', {
    template,

    computed: {
        // extend default productCriteria
        productCriteria() {
            const criteria = this.$super('productCriteria');

            criteria.addAssociation('mwsVaisProductVideoConfig');
            criteria.addAssociation('mwsVaisProductVideoConfigMedia')

            criteria.addAssociation('mwsVaisProductAiVideo.media');

            const aiVideoCriteria = criteria.getAssociation('mwsVaisProductAiVideo')
            aiVideoCriteria.addSorting(
                Criteria.sort('createdAt', 'DESC')
            )
            aiVideoCriteria.setLimit(1)

            /*criteria.getAssociation('mwsVaisProductAiVideo').addFilter(
                Criteria.equals('languageId', Shopware.Context.api.languageId)
            )*/ // TODO: Add when language is implemented in middleware

            return criteria
        },

        hasParent() {
            return this.product?.parentId == null;
        }
    },

    methods: {
        createdComponent() {
            this.$super('createdComponent');

            // Helper to trigger save method within nested components, use with helper util/product.js::saveProduct
            emitter.on('product.save', async (callbackEventName) => {
                await this.onSave();

                // onSave() returns Promise<void> -> manually checking if save was successful
                const errors = Shopware.State.getters["error/getAllApiErrors"]()
                const systemErrorCount = Shopware.State.getters["error/countSystemError"]()

                if (systemErrorCount < 1 && errors.length < 1) {
                    emitter.emit(callbackEventName, true)
                } else {
                    emitter.emit(callbackEventName, false)
                }
            })
        },

        onSave() {
            const route = this.$route

            if (route.name !== 'sw.product.detail.ai.video') {
                return this.$super('onSave');
            }

            const videoScript = this.product.extensions?.mwsVaisProductVideoConfig?.videoScript

            if (!videoScript) {
                return this.$super('onSave');
            }

            let valid = true;
            for (const scene of videoScript.scenes) {
                if (!this.validateVariables(scene)) {
                    valid = false
                }
            }

            if (!valid) {
                this.createNotificationError({
                    message: this.$tc('global.error-codes.mwsvais.videoScript.error'),
                });

                // onSave method must return a promise -> returning void promise that resolves immediately
                return new Promise((resolve) => {
                    resolve();
                });
            }

            return this.$super('onSave');
        },

        validateVariables(scene) {
            let valid = true;

            for (const variable of scene.variables) {
                switch (variable.variableType) {
                    case 'image':
                        if (
                            typeof variable.variableOutputValue !== 'string'
                            || variable.variableOutputValue.length < 1
                        ) {
                            Shopware.State.dispatch('error/addApiError', {
                                expression: `mws_vais_product_video_config.${this.product.id}.videoScript.variable.${scene.sceneId}-${variable.variableName}`,
                                error: {
                                    code: 'mwsvais.videoScript.variable.image-required',
                                    parameters: {
                                    }
                                },
                            });

                            valid = false
                        }

                        break;
                }
            }
            return valid;
        }
    }
})
