const ApiService = Shopware.Classes.ApiService;


export default class VideoScriptControlService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'video-script') {
        super(httpClient, loginService, apiEndpoint);
    }

    generateVideoScript(productId) {
        const headers = this.getBasicHeaders();

        return this.httpClient.post(
            `${this.getApiBasePath()}/generate/${productId}`,
            null,
            { headers }
        ).then((response) => {
            return ApiService.handleResponse(response);
        });
    }

    async generateBulk(productIds, scriptAndVideo) {
        const headers = this.getBasicHeaders();

        const response = await this.httpClient.post(
            `${this.getApiBasePath()}/generate-bulk`,
            {
                productIds,
                scriptAndVideo
            },
            { headers }
        )

        return ApiService.handleResponse(response);
    }
}