<?php declare(strict_types=1);

namespace VideoAISoftware\Component\Api;

use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\HttpClientInterface;
use VideoAISoftware\Util\PluginConfigService;

class MiddlewareClientFactory
{
    public function __construct(
        private readonly PluginConfigService $pluginConfigService
    )
    {
    }

    public function create(?string $apiKey = null): HttpClientInterface
    {
        $apiKey = $apiKey ?? $this->pluginConfigService->getApiKey();

        return HttpClient::create([
            'headers' => [
                'Accept' => 'application/json',
                'Authorization' => "Bearer $apiKey",
            ],
            'base_uri' => $this->pluginConfigService->getApiHost()
        ]);
    }
}