<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductSetting\Media;

use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaEntity;
use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;

class ProductSettingMediaEntity extends Entity {

    protected string $productVersionId;
    protected string $productMediaId;

    protected ?ProductEntity $product = null;
    protected ?ProductMediaEntity $productMedia = null;
    
    public function getProductVersionId() : string {
        return $this->productVersionId;
    }

    public function getProduct(): ?ProductEntity {
        return $this->product;
    }

    public function getProductMedia() : ?ProductMediaEntity {
        return $this->productMedia;
    }

    public function setProductMediaId(string $productMediaId) {
        $this->productMediaId = $productMediaId;
    }

    public function getProductMediaId() {
        return $this->productMediaId;
    }

}