<?php declare(strict_types=1);

namespace VideoAISoftware\Controller\Api;

use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\Api\Controller\ApiController;
use Shopware\Core\Framework\Validation\DataBag\RequestDataBag;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

use Symfony\Contracts\Service\Attribute\Required;
use VideoAISoftware\Services\ProductSettingService;

#[Route(defaults: ['_routeScope' => ['api']])]
class ProductSettingController extends ApiController
{
    private ProductSettingService $productSettingService;

    #[Required]
    public function setProductSettingService(ProductSettingService $productSettingService): void
    {
        $this->productSettingService = $productSettingService;
    }

    #[Route(path: '/api/product-media-settings/get', name: 'api.action.media-settings.get', methods: ['GET'])]
    public function get(Request $request): JsonResponse
    {
        $productId = $request->query->get('productId');

        return new JsonResponse($this->productSettingService->getSelectedMedia($productId));
    }

    #[Route(path: '/api/product-media-settings/save', name: 'api.action.media-settings.save', methods: ['POST'])]
    public function save(RequestDataBag $dataBag): JsonResponse
    {
        $productId = $dataBag->get('productId');
        $mediaId = $dataBag->get('mediaId');
        $selected = $dataBag->get('selected');

        return new JsonResponse($this->productSettingService->saveSelectedMedia($productId, $mediaId, $selected));
    }

    
}