const { Component } = Shopware;

Component.register('mwsvais-ai-bulk-edit', () => import('./page/mwsvais-ai-bulk-edit'));

const { Module } = Shopware;
Module.register('mwsvais-ai-bulk-edit', {
    type: 'plugin',
    name: 'ai-bulk-edit',
    title: 'mwsvais-bulk-edit.link',
    description: 'mwsvais-ai-bulk-edit.general.descriptionTextModule',
    version: '1.0.0',
    targetVersion: '1.0.0',

    routes: {
        product: {
            component: 'mwsvais-ai-bulk-edit',
            path: 'ai-video',
            meta: {
                parentPath: 'sw.product.index',
            },
            children: {
                save: {
                    component: 'sw-bulk-edit-save-modal',
                    path: 'save',

                    redirect: {
                        name: 'mwsvais.ai.bulk.edit.product.save.confirm',
                    },
                    children: {
                        confirm: {
                            component: 'sw-bulk-edit-save-modal-confirm',
                            path: 'confirm',
                        },
                        process: {
                            component: 'sw-bulk-edit-save-modal-process',
                            path: 'process',
                        },
                        success: {
                            component: 'sw-bulk-edit-save-modal-success',
                            path: 'success',
                        },
                        error: {
                            component: 'sw-bulk-edit-save-modal-error',
                            path: 'error',
                        },
                    },
                },
            },
        }
    }
});