const ApiService = Shopware.Classes.ApiService;

export default class ApiTestService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'mws-vais/ai-video-manager') {
        super(httpClient, loginService, apiEndpoint);
    }

    async generate(productId, payload = {}) {
        const headers = super.getBasicHeaders();

        const response = await super.httpClient.post(
            `${super.getApiBasePath()}/generate/${productId}`,
            payload,
            { headers }
        );

        return ApiService.handleResponse(response);
    }

    async generateBulk(productIds) {
        const headers = super.getBasicHeaders();

        const response = await super.httpClient.post(
            `${super.getApiBasePath()}/generate-bulk`,
            {
                productIds
            },
            { headers }
        )

        return ApiService.handleResponse(response)
    }

    async publishVideo(id) {
        const headers = super.getBasicHeaders();

        const response = await super.httpClient.post(
            `${super.getApiBasePath()}/publish/${id}`,
            null,
            { headers }
        );

        return ApiService.handleResponse(response);
    }

    async unpublishVideo(id) {
        const headers = super.getBasicHeaders();

        const response = await super.httpClient.post(
            `${super.getApiBasePath()}/unpublish/${id}`,
            null,
            { headers }
        );

        return ApiService.handleResponse(response);
    }
}