<?php declare(strict_types=1);

namespace VideoAISoftware\Util;

use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpKernel\KernelInterface;

readonly class ShopwareVersionHelper
{
    public function __construct(
        #[Autowire(service: KernelInterface::class)]
        private KernelInterface $kernel
    )
    {
    }

    public function getCurrentVersion(): string {
        return $this->kernel->getContainer()->getParameter('kernel.shopware_version');
    }
}