<?php declare(strict_types=1);

namespace VideoAISoftware;

use Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition;
use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Doctrine\DBAL\Connection;
use VideoAISoftware\Content\ProductAiVideo\ProductAiVideoDefinition;

class VideoAISoftware extends Plugin
{
    /**
     * Uninstall plugin and remove all related data from the database.
     *
     * @param UninstallContext $uninstallContext
     */
    public function uninstall(UninstallContext $uninstallContext): void
    {
        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }

        /** @var Connection $connection */
        $connection = $this->container->get(Connection::class);

        $this->dropTables($connection);

        $this->cleanUpMediaData($connection);
    }

    /**
     * Drop custom tables created by the plugin.
     *
     * @param Connection $connection
     */
    private function dropTables(Connection $connection): void
    {
        $tables = [
            'mws_vais_bulk_meta',
            'mws_vais_product_ai_video',
            'mws_vais_product_video_config',
            'mws_vais_product_video_config_media'
        ];

        foreach ($tables as $table) {
            $connection->executeStatement('DROP TABLE IF EXISTS `' . $table . '`');
        }
    }

    /**
     * Clean up media data related to the plugin.
     *
     * @param Connection $connection
     */
    private function cleanUpMediaData(Connection $connection): void
    {
        $defaultFolderId = $connection->createQueryBuilder()
            ->select('id')
            ->from(MediaDefaultFolderDefinition::ENTITY_NAME)
            ->where('entity = :entity')
            ->setParameter('entity', ProductAiVideoDefinition::ENTITY_NAME)
            ->executeQuery()
            ->fetchOne();

        $connection->executeStatement(
            'DELETE FROM `media_folder` WHERE `default_folder_id` = :id',
            ['id' => $defaultFolderId]
        );

        $connection->executeStatement(
            'DELETE FROM `media_default_folder` WHERE `id` = :id',
            ['id' => $defaultFolderId]);
    }
}
