<?php declare(strict_types=1);

namespace VideoAISoftware\Content\BulkMeta;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BlobField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use VideoAISoftware\Constants;

#[AutoconfigureTag('entity.definition', ['entity' => self::ENTITY_NAME])]
class BulkMetaDefinition extends EntityDefinition
{
    public const ENTITY_NAME = Constants::DATABASE_NAMESPACE . '_bulk_meta';
    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('bulk_id', 'bulkId'))->addFlags(new Required(), new PrimaryKey()),
            (new FkField('product_id', 'productId', ProductDefinition::class))
                ->addFlags(new Required(), new CascadeDelete(), new PrimaryKey()),
            (new ReferenceVersionField(ProductDefinition::class))->addFlags(new Required(), new PrimaryKey()),
            (new StringField('bulk_state', 'bulkState'))->addFlags(new Required()),
            (new OneToOneAssociationField('product', 'product_id', 'id', ProductDefinition::class, false))
                ->addFlags(new CascadeDelete()),

            new BlobField('context', 'context'),
            new BoolField('script_and_video', 'scriptAndVideo')
        ]);
    }

    public function getEntityClass(): string
    {
        return BulkMetaEntity::class;
    }

    public function getCollectionClass(): string
    {
        return BulkMetaCollection::class;
    }
}