<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductAiVideo;

use Shopware\Core\Content\Media\MediaEntity;
use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaEntity;
use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

#use Shopware\Core\System\Language\LanguageEntity;

# TODO: Add LanguageEntity when implemented in middleware

class ProductAiVideoEntity extends Entity
{
    use EntityIdTrait;

    protected string $mediaId;
    #protected string $languageId;
    protected ?string $productMediaId;
    protected bool $published;
    protected ?string $parentId;

    protected ?ProductEntity $product;
    protected ?MediaEntity $media;
    protected ?ProductMediaEntity $productMedia;
    protected ?self $parent;
    protected ?ProductAiVideoCollection $children = null;
    #protected ?LanguageEntity $language;

    public function getProductId(): string
    {
        return $this->productId;
    }

    public function getMediaId(): string
    {
        return $this->mediaId;
    }

    public function setMediaId(string $mediaId): void
    {
        $this->mediaId = $mediaId;
    }

    public function getProduct(): ?ProductEntity
    {
        return $this->product;
    }

    public function setProduct(?ProductEntity $product): void
    {
        $this->product = $product;
    }

    public function getMedia(): ?MediaEntity
    {
        return $this->media;
    }

    public function setMedia(?MediaEntity $media): void
    {
        $this->media = $media;
    }

    /*public function getLanguageId(): string
    {
        return $this->languageId;
    }

    public function setLanguageId(string $languageId): void
    {
        $this->languageId = $languageId;
    }*/

    public function isPublished(): bool
    {
        return $this->published;
    }

    public function setPublished(bool $published): void
    {
        $this->published = $published;
    }

    public function getProductMedia(): ?ProductMediaEntity
    {
        return $this->productMedia;
    }

    public function setProductMedia(?ProductMediaEntity $productMedia): void
    {
        $this->productMedia = $productMedia;
    }

    public function getProductMediaId(): ?string
    {
        return $this->productMediaId;
    }

    public function setProductMediaId(?string $productMediaId): void
    {
        $this->productMediaId = $productMediaId;
    }

    public function getParent(): ?ProductAiVideoEntity
    {
        return $this->parent;
    }

    public function setParent(?ProductAiVideoEntity $parent): void
    {
        $this->parent = $parent;
    }

    public function getParentId(): ?string
    {
        return $this->parentId;
    }

    public function setParentId(?string $parentId): void
    {
        $this->parentId = $parentId;
    }

    public function getChildren(): ?ProductAiVideoCollection
    {
        return $this->children;
    }

    public function setChildren(?ProductAiVideoCollection $children): void
    {
        $this->children = $children;
    }

    /*public function getLanguage(): ?LanguageEntity
    {
        return $this->language;
    }

    public function setLanguage(?LanguageEntity $language): void
    {
        $this->language = $language;
    }*/


}