<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1730368094MwsVaisCreateProductSelectedMediaTable extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730368094;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
        CREATE TABLE mws_vais_product_video_config_media (
            product_id BINARY(16) NOT NULL, 
            product_version_id BINARY(16) DEFAULT NULL, 
            product_media_id BINARY(16) NOT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY(product_id, product_media_id),
            FOREIGN KEY (product_id, product_version_id) 
                REFERENCES product(id, version_id) 
                ON DELETE CASCADE,
            FOREIGN KEY (product_media_id)
                REFERENCES product_media(id)
                ON DELETE CASCADE,
            KEY `mws_vais_product_video_config_media.fk.product_id_media_id` (product_id, product_media_id)
        ) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB;
        SQL;

        $connection->executeStatement($query);
    }
}
