<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1731507059MwsVaisProductAiVideo extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1731507059;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            ALTER TABLE mws_vais_product_ai_video DROP FOREIGN KEY mws_vais_product_ai_video_ibfk_1;

            ALTER TABLE mws_vais_product_ai_video DROP FOREIGN KEY mws_vais_product_ai_video_ibfk_2;

            ALTER TABLE mws_vais_product_ai_video ADD product_media_id BINARY(16) DEFAULT NULL, ADD product_media_version_id BINARY(16) DEFAULT NULL;
    
            ALTER TABLE mws_vais_product_ai_video ADD CONSTRAINT `fk.mws_vais_product_ai_video.media_id` FOREIGN KEY (media_id) 
                REFERENCES media (id) ON UPDATE CASCADE ON DELETE CASCADE;

            ALTER TABLE mws_vais_product_ai_video ADD CONSTRAINT `fk.mws_vais_product_ai_video.product_id` FOREIGN KEY (product_id, product_version_id) 
                REFERENCES product (id, version_id) ON UPDATE CASCADE ON DELETE CASCADE;

            ALTER TABLE mws_vais_product_ai_video ADD CONSTRAINT `fk.mws_vais_product_ai_video.product_media_id` FOREIGN KEY (product_media_id, product_media_version_id) 
                REFERENCES product_media (id, version_id) ON UPDATE CASCADE ON DELETE SET NULL;
SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
