
import template from './mwsvais-form-of-address.html.twig';

const { Component } = Shopware;

Component.register('mwsvais-form-of-address', {
    template,
    emits: ['update:value'],

    data() {
        return {
            formOfAddressOptions: [
                { value: 'Du', name: 'Du' },
                { value: 'Sie', name: 'Sie' },
            ],
            selectedFormOfAddress: null
        };
    },

    methods: {
        onChange(value) {
            this.$emit('update:value', value)
        }
    }
});
