Shopware.Component.extend('mwsvais-textarea-field', 'sw-textarea-field', {
    props: {
        minLength: {
            type: Number,
            required: false
        },
        maxLength: {
            type: Number,
            required: false
        }
    },

    mounted() {
        const textarea = this.$el.querySelector('textarea')
        if (!textarea) return

        if (this.minLength) {
            textarea.setAttribute('minlength', this.minLength)
        }

        if (this.maxLength) {
            textarea.setAttribute('maxlength', this.maxLength)
        }
    }
})