import template from './sw-product-video-script-control.html.twig';
import './sw-product-video-script-control.scss'
import emitter from "@MwsVais/util/mitt";
import {saveProduct} from "@MwsVais/util/product";
const { mapState } = Shopware.Component.getComponentHelper();
const {Criteria} = Shopware.Data;
const { Component, Mixin } = Shopware;

Component.register('sw-product-video-script-control', {
    template,
    inject: ['videoScriptControl', 'repositoryFactory'],
    mixins: [
        Mixin.getByName('notification')
    ],
    props: {
        productId: {
            type: String,
            required: true,
        },
    },

    data() {
        return {
            processSuccess: false,
            processFinish: false,
            pending: false
        };
    },

    mounted() {
        emitter.on('mws_vais.video_script.webhook', (payload) => {
            if (payload.productId !== this.product.id) return

            this.updateVideoScript(payload.success);
        })
    },

    unmounted() {
        emitter.off('mws_vais.video_script.webhook')
    },


    computed: {
        ...mapState('swProductDetail', [
            'product'
        ]),
        productSettingRepository() {
            return this.repositoryFactory.create('mws_vais_product_video_config');
        },
        instructions: {
            get() {
                return this.product.extensions.mwsVaisProductVideoConfig.additionalInstructions;
            },
            set(value) {
                this.product.extensions.mwsVaisProductVideoConfig.additionalInstructions = value;
            }
        },

        excludeContent: {
            get() {
                return this.product.extensions.mwsVaisProductVideoConfig.excludedContent;
            },
            set(value) {
                this.product.extensions.mwsVaisProductVideoConfig.excludedContent = value;
            }
        },

        isLoading() {
            return this.product.extensions.mwsVaisProductVideoConfig.videoScriptState === 'pending'
        },

        hasError() {
            return this.product.extensions.mwsVaisProductVideoConfig.videoScriptState === 'error'
        },

        showError() {
            return Shopware.Context.app.environment === 'development'
        }
    },


    methods: {
        async generateVideoScript() {
            try {
                this.pending = true

                if (!(await saveProduct('product.save.video-script-control'))) {
                    return;
                }

                const response = await this.videoScriptControl.generateVideoScript(this.product.id)
                this.product.extensions.mwsVaisProductVideoConfig.videoScriptState = 'pending';

                this.createNotificationSuccess({
                    title: this.$tc('mwsvais.product-detail.field.video-script-button.label'),
                    message: this.$tc(response.message)
                });
            } catch (error) {
                this.product.extensions.mwsVaisProductVideoConfig.videoScriptState = 'error'

                this.createNotificationError({
                    title: this.$tc('mwsvais.product-detail.field.video-script-button.label'),
                    message: error.response?.data?.message
                });
            } finally {
                this.pending = false
            }
        },

        async updateVideoScript(payload) {
            const criteria = new Criteria();
            criteria.setIds([this.product.id]);

            const entity = (await this.productSettingRepository.search(criteria, Shopware.Context.Api)).first()

            if (!entity) {
                this.product.extensions.mwsVaisProductVideoConfig.videoScriptState =
                    payload.success === true
                        ? 'success'
                        : 'error';

                return
            }

            this.product.extensions.mwsVaisProductVideoConfig.videoScriptState = entity.videoScriptState
            this.product.extensions.mwsVaisProductVideoConfig.videoScript = entity.videoScript
            this.product.extensions.mwsVaisProductVideoConfig.videoScriptError = entity.videoScriptError
        }
    },
});