const { Component } = Shopware;

Component.override('sw-extension-config', {

    computed: {
        isVAISConfig() {
            return this.domain === 'VideoAISoftware.config';
        },
    },

    created() {
        if (this.isVAISConfig) {
            this.hideSalesChannelSelect();
        }
    },

    methods: {
        hideSalesChannelSelect() {
            const findAndHideElement = () => {
                const salesChannelSwitch = document.querySelector('.sw-sales-channel-switch');
                if (salesChannelSwitch) {
                    // Element gefunden, anwenden
                    salesChannelSwitch.style.pointerEvents = 'none';
                    salesChannelSwitch.style.opacity = '0.6';
                    return true;
                }
                return false;
            };

            const observer = new MutationObserver(() => {
                if (findAndHideElement()) {
                    observer.disconnect();
                }
            });

            observer.observe(document.body, {
                childList: true,
                subtree: true
            });

            if (findAndHideElement()) {
                observer.disconnect();
            }
        }
    }
});
