Shopware.Component.override('sw-media-quickinfo-usage', {
    data() {
        return {
            mwsVaisProductAiVideos: []
        }
    },

    computed: {
        getUsages() {
            const usages = this.$super('getUsages');
            this.mwsVaisProductAiVideos.forEach((product) => {
                usages.push(this.getAiVideoUsage(product));
            });
            return usages
        }
    },

    methods: {
        createdComponent() {
            this.$super('createdComponent')
            this.loadAiVideosAssociations()
        },

        loadAiVideosAssociations() {
            this.mwsVaisProductAiVideos = this.item.extensions.mwsVaisProductAiVideo.map(item => item.product);
        },

        getAiVideoUsage(product) {
            return {
                name: product.translated.name,
                tooltip: this.$tc('sw-media.sidebar.usage.tooltipFoundInProducts'),
                link: {
                    name: 'sw.product.detail.ai.video',
                    id: product.id,
                },
                icon: this.getIconForModule('sw-product'),
            };
        },
    }
})
