# VideoAISoftware

## Installation

Clone git repository to {shop_root}/custom/plugins.

``git clone git@bitbucket.org:mainwebsolutions/video-ai-software-shopware6-plugin.git ``

Install and activate plugin.

```bash
php bin/console plugin:refresh && php bin/console plugin:install -ac VideoAISoftware
```

## Development

### Connect to middleware

1. Setup https://bitbucket.org/mainwebsolutions/video-ai-software-platform/src
2. Create user in admin dashboard (localhost/admin) and generate API token
3. Copy and paste API token to plugin config
4. Create template(s) for user in middleware admin dashboard (copy template ID from synthesia, don't forget to add synthesia API token to middleware .env)
5. Allow middleware and shop containers to talk to each other
   1. Create docker network ``docker network create vais``
   2. Add network to middleware and shop docker-compose as external network
   3. Stop and restart middleware and shopware container if running
   4. Get container name of middleware with ``docker inspect vais``
   5. Save middleware host in plugin config "API host": http://video-ai-software-platform-laravel.test-1/api/v1/
   6. Save shopware host in middleware user config
   7. Create sales channel domain for shopware host

### Context::createCliContext

Shopware introduced Context::createCliContext with Version [6.6.1.0](https://github.com/shopware/shopware/blob/v6.6.1.0/changelog/release-6-6-1-0/2024-02-28-add-a-createclicontext-method-to-context.md),
but we want to be compatible with Version 6.6.0.0.

Everytime you need to create a default context (no currency, language, etc. needed) you **MUST**
use [ContextHelper::createCliContext()](./src/Util/ContextHelper.php).

The ContextHelper takes care to call the correct method (for the currently installed shopware version) on the Shopware Context to instantiate a new context.

See [GenerateVideoScriptController](./src/Controller/Api/GenerateVideoScriptController/GenerateVideoScriptController.php) for usage.

### Javascript/Typescript/Scss imports from vendor/shopware/...

When importing files from vendor/shopware/administration/... in your javascript/typescript/scss files you **must not**
use relative imports like "../../../../../../vendor/shopware/...". Use webpack alias "@administration" instead, resolves to "/var/www/html/vendor/shopware/administration/Resources/app/administration/src".

Your IDE should automatically pick up the alias via tsconfig.json/jsconfig.json and show autocompletion for your import path.

Unfortunately the IDE (at least phpstorm) does not pick up the alias in scss files.

Also, "@" is not allowed in scss imports, therefore you **must** use the "~administration" import in scss files.
Since the alias is not recognized you can use relative imports during development, but replace the relative import with the "~administration" alias before creating your pull request.
**Make sure the scss still compiles without issues using the alias!**

### Snippets

When adding snippets it easily happens to add keys to the wrong places in multiple language files.
This leads to not working translations and is easy to miss during QA.

Before creating your PR you **must** validate the translations with phpunuhi.

```bash
cd {plugin_root}/phpunuhi
composer install
composer run snippets:validate 
```

To fix structural issues (missing keys in locales), run ``composer run snippets:fix``

## Deploy

### Generate zip locally

Using shopware-cli with dockware:

1. Checkout tagged commit ``git checkout 1.0.0``
2. Generate zip via shopware-cli (generated zip will include tag, e.g. VideoAISoftware-1.0.0.zip)
3. Upload zip to repository downloads in bitbucket

```bash
SHOPWARE_PROJECT_ROOT=/var/www/html shopware-cli extension zip custom/plugins/video-ai-software-shopware6-plugin/
```