<?php declare(strict_types=1);

namespace VideoAISoftware\Content\BulkMeta;

use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;

class BulkMetaEntity extends Entity
{
    protected string $productId;
    protected string $bulkId;
    protected string $bulkState;
    protected ?bool $scriptAndVideo;

    protected ?string $context;

    protected ?ProductEntity $product;

    public function getProductId(): string
    {
        return $this->productId;
    }

    public function setProductId(string $productId): void
    {
        $this->productId = $productId;
    }

    public function getProduct(): ?ProductEntity
    {
        return $this->product;
    }

    public function setProduct(?ProductEntity $product): void
    {
        $this->product = $product;
    }

    public function setBulkState(BulkState $bulkState): void
    {
        $this->bulkState = $bulkState->value;
    }

    public function getBulkState(): BulkState
    {
        return BulkState::from($this->bulkState);
    }

    public function getBulkId(): string
    {
        return $this->bulkId;
    }

    public function setBulkId(string $bulkId): void
    {
        $this->bulkId = $bulkId;
    }

    public function isScriptAndVideo(): bool
    {
        return $this->scriptAndVideo ?? false;
    }

    public function setScriptAndVideo(?bool $scriptAndVideo): void
    {
        $this->scriptAndVideo = $scriptAndVideo;
    }

    public function getContext(): Context
    {
        return unserialize($this->context);
    }

    public function setContext(Context $context): void
    {
        $this->context = serialize($context);
    }


}