<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductAiVideo;

use Shopware\Core\Content\Media\MediaEntity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityCollection;

/**
 * @extends EntityCollection<ProductAiVideoEntity>
 */
class ProductAiVideoCollection extends EntityCollection
{
    protected function getExpectedClass(): string
    {
        return ProductAiVideoEntity::class;
    }

    /**
     * @return MediaEntity[]
     */
    public function media(): array
    {
        return $this->map(fn (ProductAiVideoEntity $entity) => $entity->getMedia());
    }
}