<?php declare(strict_types=1);

namespace VideoAISoftware\Content;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use VideoAISoftware\Content\ProductAiVideo\ProductAiVideoDefinition;
use VideoAISoftware\Content\ProductSetting\Media\ProductSettingMediaDefinition;
use VideoAISoftware\Content\ProductSetting\ProductSettingDefinition;

#[AutoconfigureTag('shopware.entity.extension')]
class ProductExtension extends EntityExtension
{

    /**
     * @inheritDoc
     */
    public function getDefinitionClass(): string
    {
        return ProductDefinition::class;
    }

    public function extendFields(FieldCollection $collection): void
    {

        $collection->add(
            (new OneToOneAssociationField(
                ProductSettingDefinition::ENTITY_EXTENSION,
                'id',
                'product_id',
                ProductSettingDefinition::class,
                false
            ))
        );

        $collection->add(
            (new OneToManyAssociationField(
                ProductSettingMediaDefinition::ENTITY_EXTENSION,
                ProductSettingMediaDefinition::class,
                'product_id',
            ))
        );

        $collection->add(
            new OneToManyAssociationField(
                ProductAiVideoDefinition::ENTITY_EXTENSION,
                ProductAiVideoDefinition::class,
                'product_id',
            )
        );
    }
}