<?php declare(strict_types=1);

namespace VideoAISoftware\Content\ProductSetting;

use GuzzleHttp\Tests\Stream\Str;
use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\JsonField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\LongTextField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use VideoAISoftware\Constants;

#[AutoconfigureTag('entity.definition', ['entity' => self::ENTITY_NAME])]
class ProductSettingDefinition extends EntityDefinition {
    
    public const ENTITY_NAME = Constants::DATABASE_NAMESPACE . '_product_video_config';
    public const ENTITY_EXTENSION = Constants::NAMESPACE . 'ProductVideoConfig';

    public function getEntityName() : string {
        return self::ENTITY_NAME;
    }

    protected function defineFields() : FieldCollection {
        return new FieldCollection([
            (new FkField('product_id', 'productId', ProductDefinition::class))->addFlags(new Required(), new PrimaryKey()),
            (new ReferenceVersionField(ProductDefinition::class))->addFlags(new Required()),
            new OneToOneAssociationField('product', 'product_id', 'id', ProductDefinition::class, false),
            new StringField('video_template_id', 'videoTemplateId'),
            new BoolField('use_product_properties', 'useProductProperties'),
            new BoolField('use_manufacturer_info', 'useManufacturerInformation'),
            new BoolField('use_product_price', 'useProductPrice'),
            new BoolField('use_product_images', 'useProductImages'),
            new BoolField('remove_background_automatically','removeBackgroundAutomatically'),
            new StringField('form_of_address', 'formOfAddress'),
            new LongTextField('additional_instructions', 'additionalInstructions'), //NEW
            new LongTextField('excluded_content', 'excludedContent'), //NEW
            new LongTextField('additional_video_content', 'additionalVideoContent'),
            new StringField('video_script_state', 'videoScriptState'),
            new JsonField('video_script_error', 'videoScriptError'),
            new JsonField('video_script', 'videoScript'),
            new StringField('generate_video_state', 'generateVideoState'),
            new JsonField('generate_video_error', 'generateVideoError')
        ]);
    }

    public function getEntityClass(): string
    {
        return ProductSettingEntity::class;
    }

    public function getCollectionClass(): string 
    {
        return ProductSettingCollection::class;
    }
}