<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1730198849MwsVaisProductVideoConfig extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730198849;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            ALTER TABLE mws_vais_product_video_config DROP FOREIGN KEY mws_vais_product_video_config_ibfk_1;

ALTER TABLE mws_vais_product_video_config ADD additional_instructions LONGTEXT DEFAULT NULL, ADD excluded_content LONGTEXT DEFAULT NULL, CHANGE product_version_id product_version_id BINARY(16) DEFAULT NULL, CHANGE use_product_name use_product_name TINYINT(1) DEFAULT 0, CHANGE use_product_description use_product_description TINYINT(1) DEFAULT 0, CHANGE use_product_properties use_product_properties TINYINT(1) DEFAULT 0, CHANGE use_manufacturer_info use_manufacturer_info TINYINT(1) DEFAULT 0, CHANGE use_product_price use_product_price TINYINT(1) DEFAULT 0, CHANGE use_product_images use_product_images TINYINT(1) DEFAULT 0, CHANGE created_at created_at DATETIME NOT NULL, CHANGE updated_at updated_at DATETIME DEFAULT NULL;

ALTER TABLE mws_vais_product_video_config ADD CONSTRAINT `fk.mwsvais.product_id` FOREIGN KEY (product_id, product_version_id) REFERENCES product (id, version_id) ON UPDATE CASCADE ON DELETE CASCADE;
SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
