import template from './mwsvais-minute-account.html.twig';
import './mwsvais-minute-account.scss';

const { Component } = Shopware;

Component.register('mwsvais-minute-account', {
    template,
    inject: ['fetchMinute'],

    data() {
        return {
            isLoading: true,
            minutes: 0,
            label: this.$tc('mwsvais-usage-statistics.minuteaccount'),
        };
    },

    created() {
        this.loadMinuteAccount();
    },

    methods: {
        loadMinuteAccount() {
            this.isLoading = true;
            this.fetchMinute.getMinuteAccount({ apiKey: this.apiKey })
                .then(response => {
                    this.minutes = response.minutes || 0;
                })
                .catch(error => {
                    console.error('Failed to load minute account:', error);
                    this.minutes = 0;
                })
                .finally(() => {
                    this.isLoading = false;
                });
        },
    },

    computed: {
        apiKey() {
            return this.pluginConfig ? this.pluginConfig['VideoAISoftware.config.apiKey'] : '';
        },
        pluginConfig() {
            let $parent = this.$parent;

            while ($parent.actualConfigData === undefined) {
                $parent = $parent.$parent;
            }

            return $parent.actualConfigData.null;
        },
    },
});
