import template from './mwsvais-product-image-select.html.twig';
import './mwsvais-product-image-select.scss'

const { Component, Mixin } = Shopware;

Component.register('mwsvais-product-image-select', {
    template,
    inheritAttrs: false,

    emits: ['update:value'],

    inject: ['feature'],

    mixins: [
        Mixin.getByName('sw-form-field'),
        Mixin.getByName('remove-api-error'),
        Mixin.getByName('validation'),
    ],

    props: {
        value: {
            required: false,
        },
        mediaItems: {
            required: true
        }
    },

    data() {
        const media = this.findMediaEntity(this.value)

        return {
            currentValue: media ? this.value : null,
        };
    },

    watch: {
        value(value) {
            this.currentValue = value;
        },
    },

    methods: {
        selectImage(image) {
            const media = this.findMediaItem(image)

            if (!media) return

            this.$emit('update:value', media.mediaId)
        },

        deselectImage(image) {
            const media = this.findMediaItem(image)

            if (!media) return

            if (this.currentValue === media.mediaId) {
                this.$emit('update:value', null)
            }
        },

        findMediaItem(id) {
            return this.mediaItems.find((item) => item.id === id)
        },
        
        findMediaEntity(id) {
            return this.mediaItems.find((item) => item.mediaId === id)
        }
    },
});
