const ApiService = Shopware.Classes.ApiService;


export default class FetchVideoTemplatesService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'video-templates') {
        super(httpClient, loginService, apiEndpoint);
    }

    getVideoTemplates(params) {
        const headers = this.getBasicHeaders();

        return this.httpClient.get(
            `${this.getApiBasePath()}/get-video-templates`,
            {
                headers,
                params
            }
        ).then((response) => {
            return ApiService.handleResponse(response);
        }).catch((error) => {
            console.error('Error while fetching video templates:', error);
            throw error;
        });
    }
}