import emitter from "@MwsVais/util/mitt";

export async function saveProduct(callbackEventName, timeout= 30000) {
    try {
        return await new Promise((resolve, reject) => {
            const timeoutID = setTimeout(reject, timeout);
            emitter.emit('product.save', callbackEventName); // -> triggers product save, see Resources/app/administration/src/module/sw-product/page/sw-product-detail/index.js

            // listen for callbackEventName being emitted
            // If not emitted within 30s promise is rejected via timeout
            emitter.on(callbackEventName, (result) => {

                clearTimeout(timeoutID);
                emitter.off(callbackEventName);

                if (result) {
                    resolve(true)
                } else {
                    reject();
                }
            })
        });
    } catch (e) {
        return false;
    }
}