<?php declare(strict_types=1);

namespace VideoAISoftware\Controller\Api\AiVideoManager;
use Symfony\Component\Validator\Constraints as Assert;


readonly class VideoWebhookDto
{
    public function __construct(
        #[Assert\NotBlank]
        public string  $id,

        #[Assert\NotNull]
        public bool    $success,

        #[Assert\Url]
        public ?string $download = null,

        public ?array  $error = null,
    )
    {
    }
}